import os, subprocess, shlex, tempfile

AFTER_EFFECTS_APP = "Adobe After Effects 2025"

# JSX to run
JSX_BATCH = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/Rotate3Dtext_stroke_fully_compatible.jsx"

PROJECT   = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/Rotate3Dtext.aep"
CSV_PATH  = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/teams_rgb_correct.csv"

# AE/Template settings
COMP        = "Comp 5"
LAYER       = "TEXT"
ANIM_NAME   = "_G_1_6"       # Leading underscore will be stripped in JSX to avoid double "__"
COLORSET    = "primary"
STROKE_W    = "2"
STROKE_OVER = "1"

# Output
OUTDIR        = "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/GOAL_Simple_384"
PATH_TEMPLATE = "{league}"         # yields GOAL_Simple_384/NHL/...
OM_TEMPLATE   = "PNG Sequence"     # Template must be a PNG-sequence with 4-digit padding starting at 0000
EXT           = "_"                # Not used for PNG sequence

# League-only
LEAGUE   = "Ligue 1"                   # REQUIRED

def _make_env():
    return {
        "AE_PROJECT": PROJECT,
        "AE_CSV": CSV_PATH,
        "AE_COMP": COMP,
        "AE_LAYER": LAYER,
        "AE_ANIM": ANIM_NAME,
        "AE_COLORSET": COLORSET,
        "AE_STROKE_WIDTH": STROKE_W,
        "AE_STROKE_OVER": STROKE_OVER,
        "AE_OUTDIR": OUTDIR,
        "AE_PATH_TEMPLATE": PATH_TEMPLATE,
        "AE_OM_TEMPLATE": OM_TEMPLATE,
        "AE_EXT": EXT,
        "AE_RS_TEMPLATE": "Best Settings",
        "AE_QUIT": "1",
        "AE_LEAGUE": LEAGUE,   # ONLY league, no subsets, ever
    }

def _write_bridge_jsx(env: dict) -> str:
    def esc(s: str) -> str:
        return s.replace("\\", "\\\\").replace('"', '\\"')
    lines = [f'$.setenv("{esc(k)}","{esc(str(v))}");' for k, v in env.items()]
    lines.append(f'$.evalFile(File("{esc(JSX_BATCH)}"));')
    code = "\n".join(lines) + "\n"
    tmp = tempfile.NamedTemporaryFile(prefix="ae_bridge_", suffix=".jsx", delete=False)
    tmp.write(code.encode("utf-8")); tmp.flush(); tmp.close()
    print("---- Bridge JSX content ----\n" + code + "-----------------------------")
    return tmp.name

def run_afterfx(env: dict):
    os.makedirs(OUTDIR, exist_ok=True)
    bridge = _write_bridge_jsx(env)
    osa = [
        "osascript",
        "-e", f'tell application "{AFTER_EFFECTS_APP}" to activate',
        "-e", f'tell application "{AFTER_EFFECTS_APP}" to DoScriptFile POSIX file "{bridge}"'
    ]
    print("Running:", " ".join(shlex.quote(c) for c in osa))
    subprocess.run(osa, check=True)

if __name__ == "__main__":
    print(f"Using JSX file: {JSX_BATCH}")
    assert os.path.isfile(JSX_BATCH), f"JSX not found: {JSX_BATCH}"
    assert os.path.isfile(PROJECT),   f"Project not found: {PROJECT}"
    assert os.path.isfile(CSV_PATH),  f"CSV not found: {CSV_PATH}"

    env = _make_env()
    run_afterfx(env)
